<?php
require "config/database.php";
require "config/function.php";
require "config/functions.crud.php";
?>
<?php if (strtotime(date('Y-m-d H:i:s')) < strtotime($setting['ppdb_open'])) { ?>
    <div class="section-header">


        <h1>PENDAFTARAN BELUM DIBUKA</h1>

        <div class="clock" style="margin:2em;"></div>
        <div class="message"></div>

    </div>

    <script>
        <?php
        $datetime = strtotime($setting['ppdb_open']) - strtotime(date('Y-m-d H:i:s'));
        ?>
        var datetime = <?= $datetime ?>;
        var clock = $('.clock').FlipClock({
            clockFace: 'DailyCounter',
            autoStart: false,
            callbacks: {
                stop: function() {
                    $('.message').html('The clock has stopped!')
                }
            }
        });

        clock.setTime(datetime);
        clock.setCountdown(true);
        clock.start();
    </script>

<?php } ?>

<div class="row">
    <div class="col-12 col-md-12 col-lg-12">
        <div class="card" style="position:relative">
            <div class="card-body">
                <div id="carouselExampleIndicators3" class="carousel slide" data-ride="carousel">
                    <!-- <ol class="carousel-indicators">
                        <li data-target="#carouselExampleIndicators3" data-slide-to="0" class=""></li>
                        <li data-target="#carouselExampleIndicators3" data-slide-to="1" class=""></li>
                        <li data-target="#carouselExampleIndicators3" data-slide-to="2" class="active"></li>
                    </ol> -->
                    <div class="carousel-inner">
                        <?php $query = mysqli_query($koneksi, "select * from slide");
                        $no = 0;
                        while ($data = mysqli_fetch_array($query)) {
                            $no++;
                            if ($no == 1) {
                                $stat = 'active';
                            } else {
                                $stat = '';
                            }
                        ?>
                            <div class="carousel-item <?= $stat ?>">
                                <img class="d-block w-100" src="<?= $data['nama_slide'] ?>">
                            </div>

                        <?php } ?>
                        <!-- <div class="carousel-item">
                            <img class="d-block w-100" src="assets/img/berkas/berkas-akte-1.jpg" alt="First slide">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="assets/img/berkas/berkas-akte-1.jpg" alt="Second slide">
                        </div>
                        <div class="carousel-item active">
                            <img class="d-block w-100" src="assets/img/berkas/berkas-akte-1.jpg" alt="Third slide">
                        </div> -->
                    </div>
                    <a class="carousel-control-prev" href="#carouselExampleIndicators3" role="button" data-slide="prev">
                        <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                        <span class="sr-only">Previous</span>
                    </a>
                    <a class="carousel-control-next" href="#carouselExampleIndicators3" role="button" data-slide="next">
                        <span class="carousel-control-next-icon" aria-hidden="true"></span>
                        <span class="sr-only">Next</span>
                    </a>
                </div>
            </div>
        </div>
    </div>

</div>
<div class="row ">
    <div class="col-lg-3 col-md-6 col-sm-6 col-12 animated flipInX">
        <div class="card card-statistic-1">
            <div class="card-icon bg-primary">
                <i class="far fa-user"></i>
            </div>
            <div class="card-wrap">
                <div class="card-header">
                    <h4>Total Pendaftar</h4>
                </div>
                <div class="card-body">
                    <?= rowcount($koneksi, 'daftar') ?>
                </div>
            </div>
        </div>
    </div>
    <div class="col-lg-3 col-md-6 col-sm-6 col-12 animated flipInX">
        <div class="card card-statistic-1">
            <div class="card-icon bg-danger">
                <i class="far fa-newspaper"></i>
            </div>
            <div class="card-wrap">
                <div class="card-header">
                    <h4>Data Sekolah</h4>
                </div>
                <div class="card-body">
                    <?= mysqli_num_rows(mysqli_query($koneksi, 'select * from daftar group by asal_sekolah')) ?>
                </div>
            </div>
        </div>
    </div>
    <div class="col-lg-3 col-md-6 col-sm-6 col-12 animated flipInX">
        <div class="card card-statistic-1">
            <div class="card-icon bg-warning">
                <i class="far fa-file"></i>
            </div>
            <div class="card-wrap">
                <div class="card-header">
                    <h4>Data Jenjang</h4>
                </div>
                <div class="card-body">
                    <?= rowcount($koneksi, 'jenjang') ?>
                </div>
            </div>
        </div>
    </div>
    <div class="col-lg-3 col-md-6 col-sm-6 col-12 animated flipInX">
        <div class="card card-statistic-1">
            <div class="card-icon bg-success">
                <i class="fas fa-circle"></i>
            </div>
            <div class="card-wrap">
                <div class="card-header">
                    <h4>Kuota Pendaftaran</h4>
                </div>
                <div class="card-body">
                    <?php $kuota = mysqli_fetch_array(mysqli_query($koneksi, "select *, sum(kuota) as kuota from jenjang"));
                    echo $kuota['kuota']; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="row animated bounceInUp">

    <div class="col-12 col-sm-12 col-lg-12">
        <div class="card">

            <div class="card-body">
                <div class="row">
                    <div class="col-12 col-sm-12 col-md-4">
                        <ul class="nav nav-pills flex-column" id="myTab4" role="tablist">
                            <li class="nav-item">
                                <a class="nav-link  active show" id="home-tab4" data-toggle="tab" href="#home4" role="tab" aria-controls="home" aria-selected="false">Informasi Pendaftaran</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" id="profile-tab4" data-toggle="tab" href="#profile4" role="tab" aria-controls="profile" aria-selected="false">Syarat Pendaftaran</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" id="contact-tab4" data-toggle="tab" href="#contact4" role="tab" aria-controls="contact" aria-selected="true">Kontak Pendaftaran</a>
                            </li>
                        </ul>
                    </div>
                    <div class="col-12 col-sm-12 col-md-8">
                        <div class="tab-content no-padding" id="myTab2Content">
                            <div class="tab-pane fade active show" id="home4" role="tabpanel" aria-labelledby="home-tab4">
                                <div class="row">
                                    <div class="col-12">
                                        <div class="activities">
                                            <div class="activity">
                                                <div class="activity-icon bg-primary text-white shadow-primary">
                                                    1
                                                </div>
                                                <div class="activity-detail">
                                                    <p>Calon Siswa mendaftar di web pendaftaran.</p>
                                                    <p><button type="button" data-id="pendaftaran" class="btn klikmenu btn-danger">Daftar Sekarang</button>.</p>
                                                </div>
                                            </div>

                                        </div>
                                        <div class="activities">
                                            <div class="activity">
                                                <div class="activity-icon bg-primary text-white shadow-primary">
                                                    2
                                                </div>
                                                <div class="activity-detail">
                                                    <p>Jika selesai pendaftaran silahkan login dengan username dan password saat pendaftaran</p>
                                                    <p><button type="button" data-id="login" class="klikmenu btn btn-success">Login Masuk</button>.</p>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="activities">
                                            <div class="activity">
                                                <div class="activity-icon bg-primary text-white shadow-primary">
                                                    3
                                                </div>
                                                <div class="activity-detail">
                                                    <p>Lengkapi Formulir yang diberikan dengan data yang benar.</p>

                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane fade" id="profile4" role="tabpanel" aria-labelledby="profile-tab4">
                                <?= $setting['syarat'] ?>
                            </div>
                            <div class="tab-pane fade " id="contact4" role="tabpanel" aria-labelledby="contact-tab4">
                                <div class=" author-box">
                                    <div class="card-body">
                                        <ul class="list-unstyled user-details list-unstyled-border list-unstyled-noborder">
                                            <?php $query = mysqli_query($koneksi, "select * from kontak where status='1'");
                                            while ($data = mysqli_fetch_array($query)) {
                                            ?>
                                                <li class="media">
                                                    <img alt="image" class="mr-3 rounded-circle" width="50" src="assets/img/avatar/avatar-1.png">
                                                    <div class="media-body">
                                                        <div class="media-title"><?= $data['nama_kontak'] ?></div>
                                                        <div class="text-job text-muted"><a href="https://api.whatsapp.com/send?phone=+62<?= $data['no_kontak'] ?>&text=<?= $setting['livechat'] ?>"> <?= $data['no_kontak'] ?></a></div>
                                                    </div>
                                                </li>
                                            <?php } ?>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="row animated bounceIn">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h4>Data Statistik Sekolah</h4>
                <div class="card-header-action">

                </div>
            </div>
            <div class="card-body ">
                <div class="table-responsive">
                    <table class="table table-striped" id="sortable-table">
                        <thead>
                            <tr>
                                <th class="text-center">
                                    <i class="fas fa-th"></i>
                                </th>
                                <th>NPSN</th>
                                <th>Nama Sekolah</th>

                                <th>Pendaftar</th>
                            </tr>
                        </thead>
                        <tbody class="ui-sortable">
                            <?php $query = mysqli_query($koneksi, "select * from daftar group by asal_sekolah");
                            while ($sekolah = mysqli_fetch_array($query)) {
                                $hitung = rowcount($koneksi, 'daftar', ['asal_sekolah' => $sekolah['asal_sekolah']]);
                            ?>
                                <tr>
                                    <td>
                                        <div class="sort-handler ui-sortable-handle">
                                            <i class="fas fa-th"></i>
                                        </div>
                                    </td>
                                    <td><?= $sekolah['npsn_asal'] ?></td>
                                    <td><?= $sekolah['asal_sekolah'] ?></td>

                                    <td>
                                        <div class="badge badge-success"><?= $hitung ?></div>
                                    </td>
                                </tr>
                            <?php } ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    $(document).ready(function() {
        $('.klikmenu').click(function() {
            var menu = $(this).data('id');
            if (menu == "pendaftaran") {
                $('#btndaftar').hide();
                $('#isi_load').load('pendaftaran.php');
            } else if (menu == "login") {
                $('#isi_load').load('login.php');
            }
        });




    });
</script>